/*
 * Decompiled with CFR 0.152.
 */
package nrs.util.file;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Vector;
import nrs.util.VerticalLayout;
import nrs.util.file.DirectoryList;
import nrs.util.file.FileDialog;
import nrs.util.file.NewDirEntry;

class FileList
extends Panel
implements MouseListener {
    private Color BG_COLOR = new Color(220, 220, 220);
    private Font FILE_FONT = new Font("SansSerif", 0, 12);
    private Font DIR_FONT = new Font("SansSerif", 1, 12);
    private FileDialog fileDialog;
    private DirectoryList dirList;
    private TextField fileName;
    private Panel innerPanel;
    private ScrollPane scroll;
    private File currentDir;
    private Vector allFiles = new Vector();
    private Vector selectedFiles = new Vector();
    private boolean selectMultiple = false;
    private boolean selectDirs = false;
    private NewDirEntry newdir = null;

    public FileList(FileDialog fileDialog, DirectoryList dirList, TextField fileName) {
        this.fileDialog = fileDialog;
        this.dirList = dirList;
        this.fileName = fileName;
        this.setBackground(Color.white);
        this.currentDir = new File(System.getProperty("user.home"));
        dirList.setDirectory(this.currentDir);
        this.innerPanel = new Panel();
        this.scroll = new ScrollPane();
        this.scroll.add(this.innerPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
    }

    void setDirectory(File dir) throws FileNotFoundException {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new FileNotFoundException(dir.getPath() + " doesn't exist");
        }
        this.currentDir = dir;
        this.dirList.setDirectory(this.currentDir);
        this.updateFileList();
    }

    void setFile(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath() + " doesn't exist");
        }
        this.currentDir = new File(file.getParent());
        this.dirList.setDirectory(this.currentDir);
        this.updateFileList();
        this.selectedFiles = new Vector(1);
        Enumeration enm = this.allFiles.elements();
        while (enm.hasMoreElements()) {
            Label filelabel = (Label)enm.nextElement();
            filelabel.setBackground(this.BG_COLOR);
            this.selectedFiles.addElement(filelabel);
        }
    }

    Vector getSelectedFiles() {
        return this.selectedFiles;
    }

    public File getDirectory() {
        return this.currentDir;
    }

    void removeSelectedFiles() {
        this.selectedFiles = new Vector();
    }

    void addNewDir() {
        if (this.newdir == null) {
            this.newdir = new NewDirEntry("NewDir", this);
            this.innerPanel.add(this.newdir);
            Dimension innerSize = this.innerPanel.getSize();
            this.scroll.setScrollPosition(innerSize.width, innerSize.height);
            this.newdir.selectAll();
            this.newdir.requestFocus();
            this.scroll.validate();
        }
    }

    void addNewDir(String dirName) {
        File f = new File(this.currentDir, dirName);
        f.mkdir();
        this.removeNewDir();
    }

    void removeNewDir() {
        this.innerPanel.remove(this.newdir);
        this.newdir = null;
        this.updateFileList();
    }

    private void addFileElements(Vector fileElements, Font f) {
        Enumeration enm = fileElements.elements();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            Label l = new Label(name);
            l.setName(name);
            l.setFont(f);
            l.addMouseListener(this);
            this.innerPanel.add(l);
            this.allFiles.addElement(l);
        }
    }

    void refresh() {
        this.updateFileList();
    }

    private void updateFileList() {
        FontMetrics fm;
        System.out.println("updateFileList");
        this.allFiles.removeAllElements();
        this.selectedFiles.removeAllElements();
        String[] files = this.currentDir.list(this.fileDialog);
        Vector<String> dirsList = new Vector<String>();
        Vector<String> filesList = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            File curFile = new File(this.currentDir, files[i]);
            if (curFile.isDirectory()) {
                dirsList.addElement(files[i]);
                continue;
            }
            filesList.addElement(files[i]);
        }
        Dimension d = this.scroll.getSize();
        int height = d.height == 0 ? 200 : d.height;
        int rows = height / ((fm = this.getToolkit().getFontMetrics(this.DIR_FONT)).getHeight() + 10);
        if (rows == 0) {
            rows = 6;
        }
        int cols = files.length / rows;
        this.innerPanel.setLayout(new VerticalLayout(rows, cols));
        this.innerPanel.removeAll();
        this.addFileElements(dirsList, this.DIR_FONT);
        this.addFileElements(filesList, this.FILE_FONT);
        this.validate();
        this.scroll.setScrollPosition(0, 0);
        this.fileName.setText(null);
        this.scroll.setScrollPosition(0, 0);
        this.fileDialog.notifyFileSelectionListeners();
    }

    private void deselectFiles() {
        Enumeration enm = this.selectedFiles.elements();
        while (enm.hasMoreElements()) {
            Label filelabel = (Label)enm.nextElement();
            filelabel.setBackground(Color.white);
        }
        this.selectedFiles = new Vector();
    }

    private void updateFileNames() {
        System.out.println("updateFileNames");
        if (this.selectedFiles.size() == 1) {
            Label l = (Label)this.selectedFiles.elementAt(0);
            this.fileName.setText(l.getName());
        } else if (this.selectedFiles.size() > 1) {
            StringBuffer sb = new StringBuffer();
            Enumeration enm = this.selectedFiles.elements();
            while (enm.hasMoreElements()) {
                sb.append("\"");
                Label l = (Label)enm.nextElement();
                sb.append(l.getName());
                sb.append("\" ");
            }
            sb.setLength(sb.length() - 1);
            this.fileName.setText(sb.toString());
        }
        this.fileDialog.notifyFileSelectionListeners();
    }

    public void mouseClicked(MouseEvent e) {
        Label filelabel = (Label)e.getSource();
        File file = new File(this.getDirectory(), filelabel.getText());
        if (e.getClickCount() >= 2) {
            if (file.isDirectory()) {
                try {
                    this.setDirectory(file);
                }
                catch (FileNotFoundException fnex) {
                    // empty catch block
                }
                return;
            }
            if (this.fileDialog.getMode() == 0) {
                this.deselectFiles();
                filelabel.setBackground(this.BG_COLOR);
                this.selectedFiles.addElement(filelabel);
                this.updateFileNames();
                this.fileDialog.actionPerformed(new ActionEvent(this, 0, "open"));
            }
        }
        if (!this.selectDirs && file.isDirectory()) {
            return;
        }
        if (!this.selectMultiple) {
            this.deselectFiles();
            filelabel.setBackground(this.BG_COLOR);
            this.selectedFiles.addElement(filelabel);
            this.updateFileNames();
        } else {
            if (e.isControlDown()) {
                if (filelabel.getBackground().equals(this.BG_COLOR)) {
                    filelabel.setBackground(Color.white);
                    this.selectedFiles.removeElement(filelabel);
                } else {
                    filelabel.setBackground(this.BG_COLOR);
                    this.selectedFiles.addElement(filelabel);
                }
            } else if (e.isShiftDown()) {
                int start = this.allFiles.indexOf(filelabel);
                Label lastSelected = (Label)this.selectedFiles.elementAt(this.selectedFiles.size() - 1);
                int end = this.allFiles.indexOf(lastSelected);
                if (end == -1 || end == start) {
                    return;
                }
                if (end < start) {
                    int tmp = end;
                    end = start;
                    start = tmp;
                }
                for (int i = start; i <= end; ++i) {
                    Label l = (Label)this.allFiles.elementAt(i);
                    l.setBackground(this.BG_COLOR);
                    if (this.selectedFiles.contains(l)) continue;
                    this.selectedFiles.addElement(l);
                }
            } else {
                this.deselectFiles();
                filelabel.setBackground(this.BG_COLOR);
                this.selectedFiles.addElement(filelabel);
            }
            this.updateFileNames();
        }
    }

    void setSelectMultiple(boolean multiple) {
        this.selectMultiple = multiple;
    }

    boolean isSelectMultiple() {
        return this.selectMultiple;
    }

    void setSelectDirs(boolean selectDirs) {
        this.selectDirs = selectDirs;
    }

    boolean isSelectDirs() {
        return this.selectDirs;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

