/*
 * Decompiled with CFR 0.152.
 */
package nrs.util.file;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import nrs.util.ImageButton;
import nrs.util.file.DirectoryList;
import nrs.util.file.FileList;
import nrs.util.file.FileSelectionEvent;
import nrs.util.file.FileSelectionListener;

public class FileDialog
extends Dialog
implements ActionListener,
ComponentListener,
KeyListener,
ItemListener,
FilenameFilter,
WindowListener {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    private int mode = 0;
    private Component[] components;
    private Vector fileFilters = new Vector(1);
    private int selectedFilter;
    private Vector fileSelectionListeners;
    private Panel innerPanel;
    private DirectoryList dirs;
    private FileList filePanel;
    private TextField fileName;
    private Choice fileType;
    private Button okButton;
    private Button cancelButton;

    public FileDialog(Frame owner) {
        super(owner, true);
        this.setTitle("Open");
        this.init();
    }

    public FileDialog(Frame owner, String title) {
        super(owner, title, true);
        this.init();
    }

    public FileDialog(Frame owner, String title, int mode) {
        super(owner, title, true);
        this.mode = mode;
        this.init();
    }

    public FileDialog(Frame owner, String title, int mode, Component[] comps) {
        super(owner, title, true);
        this.mode = mode;
        this.components = comps;
        this.init();
    }

    private Panel createDirControls() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Panel p = new Panel(gbl);
        Label l = new Label("Look In:");
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        p.add((Component)l, gbc);
        this.dirs = new DirectoryList();
        this.dirs.setName("dir");
        this.dirs.addItemListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        p.add((Component)this.dirs, gbc);
        ImageButton up = new ImageButton("/nrs/util/file/UpFolder.gif");
        up.setActionCommand("updir");
        up.addActionListener(this);
        gbc.weightx = 0.0;
        p.add((Component)up, gbc);
        ImageButton home = new ImageButton("/nrs/util/file/HomeFolder.gif");
        home.setActionCommand("homedir");
        home.addActionListener(this);
        p.add((Component)home, gbc);
        ImageButton newdir = new ImageButton("/nrs/util/file/NewFolder.gif");
        newdir.setActionCommand("newdir");
        newdir.addActionListener(this);
        p.add((Component)newdir, gbc);
        return p;
    }

    private File getDirectory() {
        return this.filePanel.getDirectory();
    }

    private Panel createFileList() {
        this.filePanel = new FileList(this, this.dirs, this.fileName);
        return this.filePanel;
    }

    private void updateFileTypes() {
        this.fileType.removeAll();
        Enumeration enm = this.fileFilters.elements();
        while (enm.hasMoreElements()) {
            FileFilter filter = (FileFilter)enm.nextElement();
            this.fileType.add(filter.name);
        }
    }

    private Panel createFileControls() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Panel p = new Panel(gbl);
        Label l = new Label("File Name:");
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.fill = 2;
        gbl.setConstraints(l, gbc);
        p.add(l);
        this.fileName = new TextField();
        if (this.mode == 0) {
            this.fileName.setEditable(false);
        } else {
            this.fileName.addKeyListener(this);
        }
        gbc.weightx = 1.0;
        gbl.setConstraints(this.fileName, gbc);
        p.add(this.fileName);
        if (this.mode == 0) {
            this.okButton = new Button("Open");
            this.okButton.setActionCommand("open");
        } else {
            this.okButton = new Button("Save");
            this.okButton.setActionCommand("save");
        }
        this.okButton.addActionListener(this);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.okButton, gbc);
        p.add(this.okButton);
        l = new Label("Files of Type:");
        gbc.gridwidth = 1;
        gbl.setConstraints(l, gbc);
        p.add(l);
        this.fileType = new Choice();
        this.fileType.setName("file");
        this.fileType.addItemListener(this);
        this.updateFileTypes();
        gbc.weightx = 1.0;
        gbl.setConstraints(this.fileType, gbc);
        p.add(this.fileType);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.cancelButton, gbc);
        p.add(this.cancelButton);
        return p;
    }

    private void init() {
        this.fileFilters.addElement(new FileFilter("All Files (*.*)", "*"));
        this.selectedFilter = 0;
        this.innerPanel = new Panel(new BorderLayout());
        this.innerPanel.add((Component)this.createDirControls(), "North");
        this.innerPanel.add((Component)this.createFileControls(), "South");
        this.innerPanel.add((Component)this.createFileList(), "Center");
        this.add((Component)this.innerPanel, "Center");
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.pack();
    }

    public File[] getSelectedFiles() {
        File dir = this.filePanel.getDirectory();
        if (this.mode == 1) {
            String fn = this.fileName.getText();
            File[] fs = new File[]{new File(dir, this.fileName.getText())};
            return fs;
        }
        Vector fileNames = this.filePanel.getSelectedFiles();
        File[] fs = new File[fileNames.size()];
        int i = 0;
        Enumeration enm = fileNames.elements();
        while (enm.hasMoreElements()) {
            Label fileName = (Label)enm.nextElement();
            File f = new File(dir, fileName.getText());
            fs[i++] = f;
        }
        return fs;
    }

    protected void notifyFileSelectionListeners() {
        if (this.fileSelectionListeners != null) {
            FileSelectionEvent event = new FileSelectionEvent(this, this.getSelectedFiles());
            Enumeration enm = this.fileSelectionListeners.elements();
            while (enm.hasMoreElements()) {
                FileSelectionListener listener = (FileSelectionListener)enm.nextElement();
                listener.valueChanged(event);
            }
        }
    }

    public void setSelectedDirectory(File dir) {
        try {
            this.filePanel.setDirectory(dir);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setSelectedFile(File f) {
        try {
            this.filePanel.setFile(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void setSelectedFileFilter(String extension) {
        int index = 0;
        Enumeration enm = this.fileFilters.elements();
        while (enm.hasMoreElements()) {
            FileFilter filter = (FileFilter)enm.nextElement();
            Enumeration endEnum = filter.endings.elements();
            while (endEnum.hasMoreElements()) {
                String ending = (String)endEnum.nextElement();
                if (!ending.equalsIgnoreCase(extension)) continue;
                this.fileType.select(index);
                this.selectedFilter = index;
                this.filePanel.refresh();
                break;
            }
            ++index;
        }
    }

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        try {
            if (ac.equals("cancel")) {
                this.filePanel.removeSelectedFiles();
            } else {
                if (ac.equals("updir")) {
                    String parent = this.filePanel.getDirectory().getParent();
                    if (parent != null) {
                        File parentDir = new File(parent);
                        this.filePanel.setDirectory(parentDir);
                    }
                    return;
                }
                if (ac.equals("homedir")) {
                    String home = System.getProperty("user.home");
                    File userHome = new File(home);
                    this.filePanel.setDirectory(userHome);
                    return;
                }
                if (ac.equals("newdir")) {
                    this.filePanel.addNewDir();
                    return;
                }
                if (ac.equals("open")) {
                    if (this.filePanel.getSelectedFiles().size() == 0) {
                        this.getToolkit().beep();
                        return;
                    }
                } else if (ac.equals("save") && this.fileName.getText().length() == 0) {
                    this.getToolkit().beep();
                    return;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent e) {
        Choice c = (Choice)e.getSource();
        String name = c.getName();
        if (name.equals("file")) {
            this.selectedFilter = c.getSelectedIndex();
            if (this.selectedFilter > -1) {
                this.filePanel.refresh();
            }
        } else if (name.equals("dir")) {
            try {
                this.filePanel.setDirectory(this.dirs.getDirectory());
            }
            catch (FileNotFoundException fnex) {
                // empty catch block
            }
        }
    }

    public boolean accept(File dir, String name) {
        File f = new File(dir, name);
        if (f.isDirectory()) {
            return true;
        }
        if (this.fileFilters.size() == 0) {
            return true;
        }
        FileFilter filter = (FileFilter)this.fileFilters.elementAt(this.selectedFilter);
        if (filter == null) {
            return true;
        }
        int dotPos = name.lastIndexOf(46);
        String ending = "";
        if (dotPos > -1) {
            ending = name.substring(dotPos + 1);
        }
        Enumeration enm = filter.endings.elements();
        while (enm.hasMoreElements()) {
            String validEnding = (String)enm.nextElement();
            if (!validEnding.equals("*") && !validEnding.equalsIgnoreCase(ending)) continue;
            return true;
        }
        return false;
    }

    public void setSelectMultiple(boolean multiple) {
        this.filePanel.setSelectMultiple(multiple);
    }

    public boolean isSelectMultiple() {
        return this.filePanel.isSelectMultiple();
    }

    public void setSelectDirectories(boolean selectDirs) {
        this.filePanel.setSelectDirs(selectDirs);
    }

    public boolean isSelectDirectories() {
        return this.filePanel.isSelectDirs();
    }

    public void addFileFilter(String displayName, String ending) {
        if (displayName == null || ending == null) {
            throw new NullPointerException("Name and ending must be non-null");
        }
        this.fileFilters.addElement(new FileFilter(displayName, ending));
        this.updateFileTypes();
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        if (this.fileSelectionListeners == null) {
            this.fileSelectionListeners = new Vector(1);
        }
        this.fileSelectionListeners.addElement(listener);
    }

    Vector getFileSelectionListeners() {
        return this.fileSelectionListeners;
    }

    public void removeFileSelectionListener(FileSelectionListener listener) {
        this.fileSelectionListeners.removeElement(listener);
    }

    public void addBorderPanel(Panel panel, String constraint) {
        if (constraint.equals("East") || constraint.equals("West")) {
            this.innerPanel.add((Component)panel, constraint);
        } else if (constraint.equals("North") || constraint.equals("South")) {
            this.add((Component)panel, constraint);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent e) {
        Dimension size = this.getSize();
        Dimension min = this.getMinimumSize();
        int height = size.height;
        int width = size.width;
        boolean resize = false;
        if (size.height < min.height) {
            height = min.height;
            resize = true;
        }
        if (size.width < min.width) {
            width = min.width;
            resize = true;
        }
        if (resize) {
            ((Component)this).setSize(width, height);
        }
        this.filePanel.refresh();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            this.actionPerformed(new ActionEvent(this, 0, "open"));
        } else if (keyCode == 27) {
            this.actionPerformed(new ActionEvent(this, 0, "cancel"));
        }
    }

    int getMode() {
        return this.mode;
    }

    public void setOKButtonLabel(String label) {
        this.okButton.setLabel(label);
    }

    public void setCancelButtonLabel(String label) {
        this.cancelButton.setLabel(label);
    }

    public String getOKButtonLabel() {
        return this.okButton.getLabel();
    }

    public String getCancelButtonLabel() {
        return this.cancelButton.getLabel();
    }

    public void windowOpened(WindowEvent e) {
        this.filePanel.refresh();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    private class FileFilter {
        String name;
        Vector endings;

        public FileFilter(String name, String ending) {
            this.name = name;
            this.endings = new Vector();
            StringTokenizer str = new StringTokenizer(ending, ",");
            while (str.hasMoreTokens()) {
                this.endings.addElement(str.nextToken().trim());
            }
        }
    }
}

