/*
 * Decompiled with CFR 0.152.
 */
package nrs.util.file;

import java.awt.Choice;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class DirectoryList
extends Choice {
    private Vector roots = new Vector();

    public DirectoryList() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") > -1) {
            String[] rootLetters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
            for (int i = 0; i < rootLetters.length; ++i) {
                File root = new File(rootLetters[i] + ":");
                if (!root.exists()) continue;
                if (this.roots == null) {
                    this.roots = new Vector();
                }
                this.roots.addElement(rootLetters[i] + ":");
            }
        }
    }

    void setDirectory(File dir) {
        String sep = System.getProperty("file.separator");
        Vector tempRoots = (Vector)this.roots.clone();
        this.removeAll();
        StringBuffer tabs = new StringBuffer();
        StringTokenizer st = new StringTokenizer(dir.getPath(), sep);
        while (st.hasMoreTokens()) {
            String dirPath = st.nextToken();
            tempRoots.removeElement(dirPath);
            this.add(tabs + dirPath);
            tabs.insert(0, "  ");
        }
        this.select(this.getItemCount() - 1);
        Enumeration enm = tempRoots.elements();
        while (enm.hasMoreElements()) {
            String root = (String)enm.nextElement();
            this.add(root);
        }
    }

    File getDirectory() {
        StringBuffer dirPath = new StringBuffer();
        int index = this.getSelectedIndex();
        String sep = System.getProperty("file.separator");
        for (int i = index; i >= 0; --i) {
            String dir = this.getItem(i);
            dirPath.insert(0, sep);
            dirPath.insert(0, dir.trim());
            if (!dir.startsWith(" ")) break;
        }
        return new File(dirPath.toString());
    }
}

