/*
 * Decompiled with CFR 0.152.
 */
package nrs.util;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class VerticalLayout
extends GridLayout {
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    private int orientation = 0;

    public VerticalLayout() {
    }

    public VerticalLayout(int rows, int cols) {
        super(rows, cols);
    }

    public VerticalLayout(int rows, int cols, int hgap, int vgap) {
        super(rows, cols, hgap, vgap);
    }

    public void setOrientation(int orientation) {
        if (orientation == 0 || orientation == 1) {
            this.orientation = orientation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = this.getRows();
            int ncols = this.getColumns();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            Dimension parentSize = parent.getSize();
            int w = parentSize.width - (insets.left + insets.right);
            int h = parentSize.height - (insets.top + insets.bottom);
            w = (w - (ncols - 1) * hgap) / ncols;
            h = (h - (nrows - 1) * vgap) / nrows;
            if (this.orientation == 0) {
                int r = 0;
                int y = insets.top;
                while (r < nrows) {
                    int c = 0;
                    int x = insets.left;
                    while (c < ncols) {
                        int i = c * nrows + r;
                        if (i < ncomponents) {
                            parent.getComponent(i).setBounds(x, y, w, h);
                        }
                        ++c;
                        x += w + hgap;
                    }
                    ++r;
                    y += h + vgap;
                }
            } else {
                int r = 0;
                int y = insets.top;
                while (r < nrows) {
                    int c = 0;
                    int x = parentSize.width - insets.right - w;
                    while (c < ncols) {
                        int i = c * nrows + r;
                        if (i < ncomponents) {
                            parent.getComponent(i).setBounds(x, y, w, h);
                        }
                        ++c;
                        x -= w + hgap;
                    }
                    ++r;
                    y += h + vgap;
                }
            }
        }
    }
}

