/*
 * Decompiled with CFR 0.152.
 */
package nrs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PropertiesValidator {
    private ResourceBundle properties = null;
    private File baseDir;
    private String prefix;
    private int prefixLength = 0;
    private boolean verbose = false;
    private boolean frequency = false;
    private Map keyFrequency = new HashMap();

    public PropertiesValidator(String props, String dir, String prefix) {
        this.properties = ResourceBundle.getBundle(props);
        this.baseDir = new File(dir);
        this.prefix = prefix + "\"";
        this.prefixLength = prefix.length() + 1;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setFrequency(boolean frequency) {
        this.frequency = frequency;
    }

    private void findProperties(File javaFile) throws FileNotFoundException, IOException {
        String line;
        if (this.verbose) {
            PropertiesValidator.pr("Examining " + javaFile.getName());
        }
        BufferedReader reader = new BufferedReader(new FileReader(javaFile));
        int linenum = 0;
        while ((line = reader.readLine()) != null) {
            int index = 0;
            ++linenum;
            do {
                if ((index = line.indexOf(this.prefix, index)) <= -1) continue;
                int start = index + this.prefixLength;
                String key = line.substring(start, line.indexOf("\"", start));
                if (this.verbose) {
                    PropertiesValidator.pr("Found key " + key);
                }
                try {
                    Object val = this.properties.getObject(key);
                    if (this.frequency) {
                        Integer occurences = (Integer)this.keyFrequency.get(key);
                        if (occurences == null) {
                            occurences = new Integer(0);
                        }
                        occurences = new Integer(occurences + 1);
                        this.keyFrequency.put(key, occurences);
                    }
                }
                catch (MissingResourceException mrex) {
                    StringBuffer sb = new StringBuffer("!!! No matching key for ");
                    sb.append(key);
                    sb.append(" in ");
                    sb.append(javaFile.getAbsolutePath());
                    sb.append(" at line ");
                    sb.append(linenum);
                    PropertiesValidator.pr(sb.toString());
                }
                index += this.prefixLength;
            } while (index != -1);
        }
    }

    public void checkProperties(File dirToCheck) {
        if (dirToCheck == null) {
            dirToCheck = this.baseDir;
        }
        if (this.verbose) {
            PropertiesValidator.pr("Checking " + dirToCheck.getAbsolutePath());
        }
        if (!dirToCheck.isDirectory()) {
            return;
        }
        File[] files = dirToCheck.listFiles(new JavaSourceFilter());
        try {
            for (int i = 0; i < files.length; ++i) {
                File examineFile = files[i];
                if (examineFile.isDirectory()) {
                    this.checkProperties(examineFile);
                    continue;
                }
                this.findProperties(examineFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void printFrequency(boolean zeroFrequency) {
        if (this.frequency) {
            PropertiesValidator.pr("\nKey Frequencies");
            Enumeration<String> keysEnum = this.properties.getKeys();
            while (keysEnum.hasMoreElements()) {
                String key = keysEnum.nextElement();
                Integer occurences = (Integer)this.keyFrequency.get(key);
                if (occurences == null) {
                    PropertiesValidator.pr(key + " 0");
                    continue;
                }
                if (zeroFrequency) continue;
                PropertiesValidator.pr(key + " " + occurences);
            }
        }
    }

    private static void printHelp() {
        PropertiesValidator.pr("PropertiesValidator - checks sources files match referenced properties");
        PropertiesValidator.pr("Mandatory arguments");
        PropertiesValidator.pr("  -p properties file");
        PropertiesValidator.pr("  -d directory to recursively check");
        PropertiesValidator.pr("  -prefix prefix to message key excluding quotes");
        PropertiesValidator.pr("Optional arguments");
        PropertiesValidator.pr("  -f print key frequencies");
        PropertiesValidator.pr("  -F only print 0 key frequencies");
        PropertiesValidator.pr("  -h print this help");
        PropertiesValidator.pr("  -v verbose output");
    }

    private static void pr(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
        String props = null;
        String dir = null;
        String prefix = null;
        boolean verbose = false;
        boolean frequency = false;
        boolean zeroFrequency = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-p")) {
                    props = args[++i];
                    continue;
                }
                if (arg.equals("-d")) {
                    dir = args[++i];
                    continue;
                }
                if (arg.equals("-prefix")) {
                    prefix = args[++i];
                    continue;
                }
                if (arg.equals("-f")) {
                    frequency = true;
                    continue;
                }
                if (arg.equals("-F")) {
                    frequency = true;
                    zeroFrequency = true;
                    continue;
                }
                if (arg.equals("-h") || arg.equals("--help")) {
                    PropertiesValidator.printHelp();
                    System.exit(0);
                    continue;
                }
                if (!arg.equals("-v")) continue;
                verbose = true;
            }
        }
        catch (IndexOutOfBoundsException ioex) {
            PropertiesValidator.pr("Not enough arguments supplied");
            PropertiesValidator.printHelp();
            System.exit(-1);
        }
        if (props == null || dir == null || prefix == null) {
            PropertiesValidator.pr("Missing arguments");
            PropertiesValidator.printHelp();
            System.exit(-1);
        }
        PropertiesValidator validator = new PropertiesValidator(props, dir, prefix);
        validator.setVerbose(verbose);
        validator.setFrequency(frequency);
        validator.checkProperties(null);
        validator.printFrequency(zeroFrequency);
    }

    private class JavaSourceFilter
    implements FileFilter {
        private JavaSourceFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname.getName().toLowerCase().endsWith(".java")) {
                return true;
            }
            return pathname.isDirectory();
        }
    }
}

