/*
 * Decompiled with CFR 0.152.
 */
package nrs.util;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostfixCalculator {
    public static final String allowedOperands = "+ - / * % & | ^ ~ << >> >>>";
    private Stack stack = new Stack();
    private static final Logger log = Logger.getLogger("nrs.util.PostfixCalculator");
    private static Hashtable args = new Hashtable(22);
    static /* synthetic */ Class class$java$lang$Math;

    public static boolean isOperand(String param) {
        if (param == null) {
            return false;
        }
        return allowedOperands.indexOf(param) > -1;
    }

    public static boolean isMathFunction(String param) {
        if (param == null) {
            return false;
        }
        return args.get(param) != null;
    }

    public void add(Object item) throws IllegalArgumentException {
        block6: {
            log.entering("PostfixCalculator", "add", item);
            if (item == null) {
                throw new NullPointerException("Item is null");
            }
            if (item instanceof Number) {
                this.addNumber((Number)item);
                return;
            }
            if (item instanceof String) {
                try {
                    this.addNumber(new Double(item.toString()));
                    return;
                }
                catch (NumberFormatException nfex) {
                    String sitem = item.toString();
                    if (PostfixCalculator.isOperand(sitem)) {
                        this.addCheckedOperand(sitem);
                        return;
                    }
                    if (!PostfixCalculator.isMathFunction(sitem)) break block6;
                    this.addMathFunction(sitem);
                    return;
                }
            }
        }
        throw new IllegalArgumentException(item + " isn't a number, operand or function");
    }

    public void add(long num) {
        this.addNumber(new Long(num));
    }

    public void add(double num) {
        this.addNumber(new Double(num));
    }

    public void addNumber(Number num) {
        log.entering("PostfixCalculator", "addNumber", num);
        this.stack.push(num);
    }

    private void addCheckedOperand(String op) {
        log.entering("PostfixCalculator", "addCheckedOperand", op);
        int size = this.stack.size();
        if (size == 0 || op.equals("~") && size < 1 || size < 2) {
            throw new IllegalArgumentException("Not enough numbers on stack for operand");
        }
        this.stack.push(op);
        this.calculate();
    }

    public void addOperand(String op) throws IllegalArgumentException {
        log.entering("PostfixCalculator", "addOperand", op);
        if (!PostfixCalculator.isOperand(op)) {
            throw new IllegalArgumentException(op + " is not an allowed operand");
        }
        this.addCheckedOperand(op);
    }

    private int getMathArguments(String function) {
        Integer argI = (Integer)args.get(function);
        if (argI == null) {
            throw new IllegalArgumentException(function + " is not a legal function");
        }
        return argI;
    }

    public void addMathFunction(String function) throws IllegalArgumentException {
        log.entering("PostfixCalculator", "addMathFunction", function);
        if (function == null) {
            throw new IllegalArgumentException("No function specified");
        }
        if (function.equals("random")) {
            this.addNumber(new Double(Math.random()));
            return;
        }
        int argCount = this.getMathArguments(function);
        Class[] methArgs = null;
        if (argCount == 1) {
            methArgs = new Class[]{Double.TYPE};
        } else if (argCount == 2) {
            methArgs = new Class[]{Double.TYPE, Double.TYPE};
        } else if (argCount != 0) {
            throw new IllegalArgumentException(function + " is not a legal function");
        }
        try {
            Method meth = (class$java$lang$Math == null ? (class$java$lang$Math = PostfixCalculator.class$("java.lang.Math")) : class$java$lang$Math).getDeclaredMethod(function, methArgs);
            this.stack.add(meth);
            this.calculate();
            return;
        }
        catch (NoSuchMethodException nsmex) {
            throw new IllegalArgumentException(function + " is not a legal function");
        }
    }

    public void reset() {
        this.stack.removeAllElements();
    }

    public Double getResult() {
        Object o;
        if (this.stack.size() > 0 && (o = this.stack.peek()) instanceof Number) {
            Number num = (Number)o;
            return new Double(num.doubleValue());
        }
        return null;
    }

    private void checkTopOfStackIsNumber() {
        Object item = this.stack.peek();
        if (!(item instanceof Number)) {
            throw new IllegalStateException("Top of stack isn't a number");
        }
    }

    private void calculateMethod(Method meth) {
        Object[] args;
        log.entering("PostfixCalculator", "calculateMethod", meth);
        int i = this.getMathArguments(meth.getName());
        this.checkTopOfStackIsNumber();
        Number num1 = (Number)this.stack.pop();
        if (i == 1) {
            args = new Object[]{new Double(num1.doubleValue())};
        } else {
            this.checkTopOfStackIsNumber();
            args = new Object[2];
            Number num2 = (Number)this.stack.pop();
            args[0] = new Double(num2.doubleValue());
            args[1] = new Double(num1.doubleValue());
        }
        try {
            this.stack.push((Double)meth.invoke(null, args));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot invoke " + meth.getName());
        }
    }

    private void calculateOperator(String op) {
        log.entering("PostfixCalculator", "calculateOperator", op);
        Number num1 = (Number)this.stack.pop();
        if (op.equals("~")) {
            int i = ~num1.intValue();
            this.stack.push(new Integer(i));
            return;
        }
        Number num2 = (Number)this.stack.pop();
        Number temp = num1;
        num1 = num2;
        num2 = temp;
        if (op.equals("+")) {
            this.stack.push(this.add(num1, num2));
        } else if (op.equals("-")) {
            this.stack.push(this.subtract(num1, num2));
        } else if (op.equals("*")) {
            this.stack.push(this.multiply(num1, num2));
        } else if (op.equals("/")) {
            this.stack.push(this.divide(num1, num2));
        } else if (op.equals("%")) {
            this.stack.push(this.remainder(num1, num2));
        } else if (op.equals("^")) {
            this.stack.push(this.xor(num1, num2));
        } else if (op.equals("|")) {
            this.stack.push(this.or(num1, num2));
        } else if (op.equals("&")) {
            this.stack.push(this.and(num1, num2));
        } else if (op.equals("<<")) {
            this.stack.push(this.leftShift(num1, num2));
        } else if (op.equals(">>")) {
            this.stack.push(this.rightShift(num1, num2));
        } else if (op.equals(">>>")) {
            this.stack.push(this.rightShiftZeroFill(num1, num2));
        }
    }

    private void calculate() throws IllegalArgumentException, IllegalStateException {
        log.entering("PostfixCalculator", "calculate");
        Object obj = this.stack.peek();
        if (obj instanceof Number) {
            throw new IllegalArgumentException("Last item isn't an operand or function");
        }
        if (this.stack.size() < 2) {
            throw new IllegalStateException("Not enough arguments to perform calculation");
        }
        Object op = this.stack.peek();
        if (!(op instanceof String) && !(op instanceof Method)) {
            throw new IllegalStateException("Top of stack isn't an operand or function");
        }
        op = this.stack.pop();
        if (op instanceof String) {
            this.calculateOperator((String)op);
        } else if (op instanceof Method) {
            this.calculateMethod((Method)op);
        }
        log.exiting("PostfixCalculator", "calculate");
    }

    private Double add(Number num1, Number num2) {
        return new Double(num1.doubleValue() + num2.doubleValue());
    }

    private Double subtract(Number num1, Number num2) {
        return new Double(num1.doubleValue() - num2.doubleValue());
    }

    private Double multiply(Number num1, Number num2) {
        return new Double(num1.doubleValue() * num2.doubleValue());
    }

    private Double divide(Number num1, Number num2) {
        return new Double(num1.doubleValue() / num2.doubleValue());
    }

    private Double power(Number num1, Number num2) {
        return new Double(Math.pow(num1.doubleValue(), num2.doubleValue()));
    }

    private Double remainder(Number num1, Number num2) {
        return new Double(num1.doubleValue() % num2.doubleValue());
    }

    private Integer and(Number num1, Number num2) {
        return new Integer(num1.intValue() & num2.intValue());
    }

    private Integer or(Number num1, Number num2) {
        return new Integer(num1.intValue() | num2.intValue());
    }

    private Integer xor(Number num1, Number num2) {
        return new Integer(num1.intValue() ^ num2.intValue());
    }

    private Integer leftShift(Number num1, Number num2) {
        return new Integer(num1.intValue() << num2.intValue());
    }

    private Integer rightShift(Number num1, Number num2) {
        return new Integer(num1.intValue() >> num2.intValue());
    }

    private Integer rightShiftZeroFill(Number num1, Number num2) {
        return new Integer(num1.intValue() >>> num2.intValue());
    }

    public void parseCalculation(String calculation) {
        log.entering("PostfixCalculator", "parseCalculation", calculation);
        StringTokenizer st = new StringTokenizer(calculation.trim(), " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.add(token);
        }
    }

    public void clear() {
        this.stack.clear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.stack.size() * 2);
        Enumeration enm = this.stack.elements();
        while (enm.hasMoreElements()) {
            String item = enm.nextElement().toString();
            sb.append(item);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please specify the calculation on the command line separated by spaces");
            System.exit(-1);
        }
        PostfixCalculator pc = new PostfixCalculator();
        StringBuffer sb = new StringBuffer(args.length);
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
            sb.append(" ");
        }
        try {
            pc.parseCalculation(sb.toString().trim());
            Double result = pc.getResult();
            System.out.println(sb.toString().trim() + " = " + result);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log.setLevel(Level.ALL);
        Method[] methods = (class$java$lang$Math == null ? (class$java$lang$Math = PostfixCalculator.class$("java.lang.Math")) : class$java$lang$Math).getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] methodArgs = method.getParameterTypes();
            if (methodArgs.length == 1 && methodArgs[0].equals(Double.TYPE)) {
                args.put(method.getName(), new Integer(1));
                continue;
            }
            if (methodArgs.length == 2 && methodArgs[0].equals(Double.TYPE) && methodArgs[1].equals(Double.TYPE)) {
                args.put(method.getName(), new Integer(2));
                continue;
            }
            if (methodArgs.length != 0 || !method.getName().equals("random")) continue;
            args.put(method.getName(), new Integer(0));
        }
    }
}

