/*
 * Decompiled with CFR 0.152.
 */
package nrs.util;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;

public class ImageButton
extends Component
implements MouseListener {
    private Image image;
    private Image bufferImage;
    private Graphics bufferGraphics;
    private Dimension bufferDim;
    private boolean pressed = false;
    private String actionCommand = "";
    private ActionListener actionListener;

    public ImageButton(String imageFile) {
        this.setImage(imageFile);
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.bufferGraphics == null || d.width != this.bufferDim.width || d.height != this.bufferDim.height) {
            this.bufferDim = d;
            this.bufferImage = this.createImage(d.width, d.height);
            this.bufferGraphics = this.bufferImage.getGraphics();
        }
        this.bufferGraphics.setColor(this.getBackground());
        this.bufferGraphics.fillRect(0, 0, d.width, d.height);
        this.bufferGraphics.draw3DRect(0, 0, d.width - 1, d.height - 1, !this.pressed);
        if (this.image != null) {
            int loc = this.pressed ? 3 : 2;
            this.bufferGraphics.drawImage(this.image, loc, loc, d.width - 5, d.height - 5, this);
        }
        g.drawImage(this.bufferImage, 0, 0, this);
    }

    public void setImage(String imageFile) {
        URL url = this.getClass().getResource(imageFile);
        if (url != null) {
            this.image = Toolkit.getDefaultToolkit().getImage(url);
            if (this.image != null) {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                try {
                    tracker.waitForAll();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this) + 4, this.image.getHeight(this) + 4);
        }
        return new Dimension(4, 4);
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        this.pressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent arg0) {
        this.pressed = false;
        this.repaint();
        this.processEvent(new ActionEvent(this, 1001, this.getActionCommand()));
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        ActionListener listener = this.actionListener;
        if (listener != null) {
            listener.actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }
}

