/*
 * Decompiled with CFR 0.152.
 */
package nrs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import nrs.util.CSVListener;

public class CSVParser
implements CSVListener {
    private CSVListener listener = null;
    private BufferedReader reader = null;
    private String fieldDelimiter = new String(",").intern();
    private String textDelimiter = new String("\"").intern();
    private boolean stop = false;
    private boolean readAll = false;
    private boolean textField = false;
    private int lineNum;
    private StringBuffer sb = new StringBuffer();
    private boolean noTextDelimiter = false;
    private boolean pauseOnValue = false;
    private static final String SPACE = " ";

    public CSVParser() {
    }

    public CSVParser(BufferedReader reader, String fieldDelimiter, String textDelimiter, CSVListener listener) {
        this.reader = reader;
        this.listener = listener;
        this.fieldDelimiter = fieldDelimiter;
        this.textDelimiter = textDelimiter;
    }

    public void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public void setListener(CSVListener listener) {
        this.listener = listener;
    }

    public CSVListener getListener() {
        return this.listener;
    }

    public void setFieldDelimiter(String fDelim) {
        this.fieldDelimiter = fDelim;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setTextDelimiter(String tDelim) {
        this.textDelimiter = tDelim;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }

    public boolean isNoTextDelimiter() {
        return this.noTextDelimiter;
    }

    public void setNoTextDelimiter(boolean noTextDelimiter) {
        this.noTextDelimiter = noTextDelimiter;
    }

    public void parse() throws IOException {
        String line;
        if (this.reader == null || this.listener == null) {
            throw new IOException("Either the BufferedReader or CSVListener have not been set");
        }
        this.lineNum = 0;
        while ((line = this.reader.readLine()) != null && !this.stop) {
            this.parseLine(line, this.lineNum++);
        }
        if (this.sb.length() > 0) {
            this.listener.newCSVValue(this.sb.toString(), this.lineNum++);
        }
        this.listener.noMoreCSVValues();
        this.readAll = true;
    }

    private void parseLine(String line, int lineNum) {
        if (this.textField && line.length() == 0) {
            this.sb.append("\n");
            return;
        }
        for (int i = 0; i < line.length(); ++i) {
            String s = line.substring(i, i + 1).intern();
            if (s.equals(this.textDelimiter)) {
                boolean bl = this.textField = !this.textField;
                if (!this.textField || line.length() != 1) continue;
                this.sb.append("\n");
                continue;
            }
            if (s.equals(this.fieldDelimiter) && !this.textField) {
                this.listener.newCSVValue(this.sb.toString(), lineNum);
                this.sb = new StringBuffer();
            } else if (s.equals(SPACE)) {
                if (this.textField || this.noTextDelimiter) {
                    this.sb.append(s);
                }
            } else {
                this.sb.append(s);
            }
            if (this.stop) break;
        }
        if (this.sb.length() > 0) {
            if (this.textField) {
                this.sb.append("\n");
            } else {
                this.listener.newCSVValue(this.sb.toString(), lineNum);
                this.sb = new StringBuffer();
            }
        }
    }

    public void stop() {
        this.stop = true;
    }

    public boolean hasReadAll() {
        return this.readAll;
    }

    private void setPauseOnValue(boolean pauseOnValue) {
        this.pauseOnValue = pauseOnValue;
    }

    public void newCSVValue(String value, int lineNum) {
        if (this.pauseOnValue) {
            System.out.print("CSV value on line " + lineNum + ": '" + value + "'");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            try {
                String s = reader.readLine();
                if (s.equalsIgnoreCase("q")) {
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                System.exit(-1);
            }
        } else {
            System.out.println("CSV value on line " + lineNum + ": '" + value + "'");
        }
    }

    public void noMoreCSVValues() {
    }

    private static void printHelp() {
        System.out.println("CSVParser <arguments>");
        System.out.println(" -h   print this help");
        System.out.println(" -csv CSV file to parse (required)");
        System.out.println(" -f   field delimiter (default ,)");
        System.out.println(" -p   pause on each found value");
        System.out.println(" -t   text delimiter (default \")");
        System.out.println(" -nt no text delimiter");
        System.out.println("Use t for tab, s for space.\n");
        System.exit(0);
    }

    public static void main(String[] args) {
        String filename = null;
        String fDelim = ",";
        String tDelim = "\"";
        boolean pause = false;
        boolean noTextDelimiter = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-h") || arg.equals("--help")) {
                    CSVParser.printHelp();
                    continue;
                }
                if (arg.equals("-csv")) {
                    filename = args[++i];
                    continue;
                }
                if (arg.equals("-f")) {
                    if ((fDelim = args[++i]).length() > 1) {
                        System.err.println("Field delimiter must be one character");
                        System.exit(-1);
                    }
                    if (!fDelim.equals("t")) continue;
                    fDelim = "\t";
                    continue;
                }
                if (arg.equals("-nt")) {
                    noTextDelimiter = true;
                    continue;
                }
                if (arg.equals("-p")) {
                    pause = true;
                    continue;
                }
                if (!arg.equals("-t")) continue;
                if ((tDelim = args[++i]).length() > 1) {
                    System.err.println("Text delimiter must be one character");
                    System.exit(-1);
                }
                if (!tDelim.equals("s")) continue;
                tDelim = SPACE;
            }
        }
        catch (IndexOutOfBoundsException iex) {
            System.err.println("Not enough arguments specified");
            CSVParser.printHelp();
        }
        if (filename == null) {
            System.err.println("Missing CSV filename");
            System.exit(-1);
        }
        try {
            File f = new File(filename);
            if (!f.exists()) {
                System.err.println("Cannot find " + filename);
                System.exit(-1);
            }
            BufferedReader reader = new BufferedReader(new FileReader(f));
            CSVParser parser = new CSVParser();
            parser.setReader(reader);
            parser.setListener(parser);
            parser.setFieldDelimiter(fDelim);
            parser.setTextDelimiter(tDelim);
            parser.setNoTextDelimiter(noTextDelimiter);
            if (pause) {
                parser.setPauseOnValue(pause);
                System.out.println("Press enter after to see each value. Type q to exit.");
            }
            parser.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

